/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.path;

import com.ibm.hwmca.fw.rcs.PathManager;
import com.ibm.hwmca.fw.rcs.RcsConfig;
import com.ibm.hwmca.fw.rcs.RcsControl;
import com.ibm.hwmca.fw.rcs.conndata.CecInfo;
import com.ibm.hwmca.fw.rcs.conndata.LparInfo;
import com.ibm.hwmca.fw.rcs.path.CallHomePath;
import com.ibm.hwmca.fw.rcs.path.InvalidStateException;
import com.ibm.hwmca.fw.rcs.path.PathCancelReason;
import com.ibm.hwmca.fw.rcs.path.PathCancelledException;
import com.ibm.hwmca.fw.rcs.path.PathFailedException;
import com.ibm.hwmca.fw.rcs.path.PathPlatform;
import com.ibm.hwmca.fw.rcs.path.PathPriority;
import com.ibm.hwmca.fw.rcs.path.PathState;
import com.ibm.hwmca.fw.rcs.path.RcsPath;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.NamedTimer;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;

public class RemoteServiceCallHomePath
extends CallHomePath {
    private static final String TRACE_MASKT = "XRCSSCPT";
    private static final String TRACE_MASKF = "XRCSSCPF";
    private static final String TRACE_MASKD = "XRCSSCPD";
    private boolean localAccess;
    private CecInfo localInfo;
    private CecInfo cecInfo;
    private static final int STATUS_TIMEOUT = 120000;
    private static Timer statusTimer = new NamedTimer(true, "RemoteService Status Timer");
    private TimerTask statusTask;

    public RemoteServiceCallHomePath(PathPlatform platform, boolean localAccess, CecInfo localInfo, CecInfo cecInfo) {
        this(platform, PathPriority.HIGH, new LocalizableText("Remote Service VPN Path"), localAccess, localInfo, cecInfo);
    }

    public RemoteServiceCallHomePath(PathPlatform platform, LocalizableText text, boolean localAccess, CecInfo localInfo, CecInfo cecInfo) {
        this(platform, PathPriority.HIGH, text, localAccess, localInfo, cecInfo);
    }

    public RemoteServiceCallHomePath(PathPlatform platform, PathPriority priority, LocalizableText text, boolean localAccess, CecInfo localInfo, CecInfo cecInfo) {
        super(platform, priority, text);
        this.localAccess = localAccess;
        this.localInfo = localInfo;
        this.cecInfo = cecInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws InvalidStateException, PathCancelledException, PathFailedException {
        Trace.trace(TRACE_MASKT, "--> open()");
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.state != PathState.WAITING) {
                    throw new InvalidStateException(this.state, PathState.WAITING);
                }
                this.state = PathState.OPENING;
                PathManager.getPathManager().openPath(this.pathId);
                Trace.trace(TRACE_MASKD, "  ] blocking after openPath() until notified");
                this.lock.wait();
                if (this.state == PathState.CANCELLED) {
                    if (this.cancelReason == PathCancelReason.LINK) {
                        throw new PathFailedException();
                    }
                    throw new PathCancelledException();
                }
                RcsConfig config = RcsConfig.getRcsConfig();
                config.setTemporaryConfigValue("rs_hmc_allow", this.localAccess ? "1" : "0");
                if (this.localInfo != null) {
                    config.setTemporaryConfigValue("rs_hmc_mtms", this.localInfo.getType() + "-" + this.localInfo.getModel() + "*" + this.localInfo.getSerial());
                } else {
                    config.setTemporaryConfigValue("rs_hmc_mtms", "00000-0000*000000");
                }
                if (this.cecInfo != null && this.cecInfo.getPartitions() != null) {
                    Iterator i = this.cecInfo.getPartitions().iterator();
                    int pId = 0;
                    while (pId <= 5) {
                        if (i.hasNext()) {
                            LparInfo info = (LparInfo)i.next();
                            config.setTemporaryConfigValue("rs_cec_" + pId, info.getNumber() + "*" + info.getType() + "-" + info.getModel() + "*" + info.getSerial());
                        } else {
                            config.setTemporaryConfigValue("rs_cec_" + pId, "");
                        }
                        ++pId;
                    }
                } else {
                    int pId = 0;
                    while (pId <= 5) {
                        config.setTemporaryConfigValue("rs_cec_" + pId, "");
                        ++pId;
                    }
                }
                int rc = RcsControl.startServiceVpn();
                if (rc != 0) {
                    this.close();
                    throw new PathFailedException("Failed to start Service VPN (RC: " + rc + ")");
                }
                this.statusTask = new StatusTimerTask(this);
                statusTimer.schedule(this.statusTask, 120000L, 120000L);
            }
            catch (PathCancelledException e) {
                throw e;
            }
            catch (PathFailedException e) {
                throw e;
            }
            catch (InvalidStateException e) {
                throw e;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Exception: " + e);
            }
        }
        Trace.trace(TRACE_MASKT, "<-- open()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Trace.trace(TRACE_MASKT, "--> close()");
        RemoteServiceCallHomePath remoteServiceCallHomePath = this;
        synchronized (remoteServiceCallHomePath) {
            try {
                if (this.statusTask != null) {
                    this.statusTask.cancel();
                }
                this.state = PathState.CLOSING;
                RcsControl.stopServiceVpn();
                PathManager.getPathManager().closePath(this.pathId);
                this.state = PathState.READY;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Exception: " + e);
            }
        }
        Trace.trace(TRACE_MASKT, "<-- close()");
    }

    private class StatusTimerTask
    extends TimerTask {
        RcsPath path;

        public StatusTimerTask(RcsPath path) {
            Trace.trace(RemoteServiceCallHomePath.TRACE_MASKT, "<-> StatusTimerTask()");
            this.path = path;
        }

        public void run() {
            Trace.trace(RemoteServiceCallHomePath.TRACE_MASKT, "--> StatusTimerTask.run()");
            if (RcsControl.serviceStatus() != 0) {
                PathManager.getPathManager().cancelPath(this.path.getPathIdentifier(), PathCancelReason.APPLICATION);
            }
            Trace.trace(RemoteServiceCallHomePath.TRACE_MASKT, "<-- StatusTimerTask.run()");
        }
    }
}

